/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.entity.pathfinding.pathjobs;

import com.minecolonies.coremod.entity.pathfinding.Node;
import com.minecolonies.coremod.entity.pathfinding.pathjobs.AbstractPathJob;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;

public class PathJobCanSee
extends AbstractPathJob {
    private final LivingEntity lookTarget;
    private final LivingEntity searchingEntity;

    public PathJobCanSee(LivingEntity searchingEntity, LivingEntity lookTarget, World world, @NotNull BlockPos start, int range) {
        super(world, start, start, range, searchingEntity);
        this.searchingEntity = searchingEntity;
        this.lookTarget = lookTarget;
    }

    @Override
    protected double computeHeuristic(BlockPos pos) {
        return this.searchingEntity.func_233580_cy_().func_218139_n((Vector3i)pos);
    }

    @Override
    protected boolean isAtDestination(Node n) {
        if (this.start.func_177956_o() - n.pos.func_177956_o() > 2) {
            return false;
        }
        return this.canSeeTargetFromPos(n.pos);
    }

    @Override
    protected double getNodeResultScore(@NotNull Node n) {
        return this.start.func_218139_n((Vector3i)n.pos);
    }

    private boolean canSeeTargetFromPos(BlockPos pos) {
        Vector3d vec3d1;
        Vector3d vec3d = new Vector3d((double)pos.func_177958_n(), (double)((float)pos.func_177956_o() + ((LivingEntity)this.entity.get()).func_70047_e()), (double)pos.func_177952_p());
        return this.world.func_217299_a(new RayTraceContext(vec3d, vec3d1 = new Vector3d(this.lookTarget.func_226277_ct_(), this.lookTarget.func_226280_cw_(), this.lookTarget.func_226281_cx_()), RayTraceContext.BlockMode.COLLIDER, RayTraceContext.FluidMode.NONE, (Entity)this.entity.get())).func_216346_c() == RayTraceResult.Type.MISS;
    }
}

